/*
*********************************************************************************************************
*									SIMPLE SOFTWARE DELAY FUNCTIONS
*
* File name		: delay.h
* Programmer 	: John Leung, TechToys. Hong Kong
* Web presence  : www.TechToys.com.hk
* Note			: 
* Language		: Keil C 7.xx 2K limited version under uVision2 IDE
* Hardware		: not specified
* Date			: Version 0.0 (30th May 2006)
*********************************************************************************************************
*											DESCRIPTION
*
* This module provides interface for simple software delay functions adjusted for external
* crystal of 11.0592MHz
*********************************************************************************************************
*/

#ifndef _DELAY_H_
#define _DELAY_H_

/*
*********************************************************************************************************
*                         				DELAY MICRO-SECOND FUNCTION
*
* Description : This function implements a software delay in usec. However, this is NOT an exact
*				usec delay function.
*				Timing calculation as (13*N+26)us at 11.0592MHz, (12*N+24)us at 12MHz
* Arguments   : 'N'		time to delay, (13*N+26)us, adjusted for external crystal of 11.0592MHz,
*						12 clock cycle timing
*			
* Returns     : none
*********************************************************************************************************
*/
void DelayUs(unsigned int N);

/*
*********************************************************************************************************
*                         				DELAY MILLI-SECOND FUNCTION
*
* Description : This function implements a software delay in millisec. Parameters adjusted for an 
*				external crystal of 11.0592MHz, with mcu of 12 clock cycle		
* Arguments   :	'msec'		time to delay, roughly in millisec timing
*			
* Returns     : none
*********************************************************************************************************
*/
void DelayMs(unsigned int msec);

#endif

